function [IM,ill]=create_image(sur_num,im_size,Ill_Ind,mode,Noise, noise_feature)
% clc
% clear
% mode=1; shows the resulting image
% sur_num=60;
% im_size=512;
% Noise=0;

load Initialization
ill_num=size(Ill,2);


[m,n]=size(Test);
Sur_Ind=round(n*rand(1,sur_num));
% choosing the surface indices
Sur_Ind=Sur_Ind+(Sur_Ind==0).*ones(1,sur_num);

% choosing the illuminant randomly 
% % Ill_Ind=round(size(Ill,2)*rand);
% % Ill_Ind=Ill_Ind+(Ill_Ind==0);   %to assure that the index is not zero

C_ill=C.*repmat(Ill(:,Ill_Ind),1,3);
ill=sum(C_ill);
ill=ill/sqrt(sum(ill.^2));


% 100 is a scale to fit in RGB
Surfs=C_ill'*Test(:,Sur_Ind); % scale for ill , set of 87 illuminant to remove the effect of saturation


% incorporating the effect of saturation
% Surfs=255*(Surfs>255)+(Surfs<=255).*(Surfs);
% Surfs_can=255*(Surfs_can>255)+(Surfs_can<=255).*(Surfs_can);

IM=zeros(im_size,im_size,3);
patch_size=floor(im_size/sqrt(sur_num));

for i=1:sqrt(sur_num)
    for j=1:sqrt(sur_num)
        Aux(1,1,:)=Surfs(:,j+(i-1)*sqrt(sur_num));
        IM([(i-1)*patch_size+1:i*patch_size],[(j-1)*patch_size+1:j*patch_size],:)=repmat(Aux(1,1,:),patch_size,patch_size);
    end
end
        

% Adding Noise to the Image
if Noise==1
    IM=IM+noise_feature(2)*imnoise(IM,'gaussian',noise_feature(1));
end


% adjusting the luminance of the image 
rat= max(IM(:)) / (2^8-1);
IM= uint8(IM/rat);

if mode==1
    figure
    imshow(IM)
end
